/*
 * Diese Datei ist Teil des GDialog Projektes:
 * "Gigaset-Erweiterung fr ProjectX"
 * 
 * Das GDialog Projekt ist freigegeben unter
 * der GNU Public Licence (GPL), deren Text sich in
 * dem Quellen-Verzeichnis befindet. Ist er dort nicht
 * mehr vorhanden, so kann er unter http://www.gnu.org/licenses/gpl.html
 * eingesehen werden.
 */
package de.m740.projectx.gigaset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.xinput.XInputDirectory;
import net.sourceforge.dvb.projectx.xinput.XInputFile;
import net.sourceforge.dvb.projectx.xinput.ftp.FtpVO;

import org.apache.commons.net.ftp.FTP;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;

/**
 * GFTPFactory
 * 
 * @author Arno
 * @version $Id: GFTPHandler.java,v 1.2 2006/12/18 20:48:04 java Exp $
 */
public class GFTPHandler {

    protected boolean debug = false;

    public GFTPHandler() {
        super();
    }

    /**
     * Copied from XInputFileImpl.getUserFTPCommand()
     * 
     * @throws java.io.IOException
     */
    private String[] getUserFTPCommand() {

        StringTokenizer st = new StringTokenizer(Common.getSettings()
                .getProperty(Keys.KEY_FtpServer_Commands), "|");
        String[] tokens = new String[st.countTokens()];

        for (int i = 0; st.hasMoreTokens(); i++)
            tokens[i] = st.nextElement().toString().trim();

        return tokens;
    }

    /**
     * Copied from XInputFileImpl.randomAccessOpen()
     * 
     * @param inpFtpVO
     * @return FTPClient
     */
    public FTPClient openClient(FtpVO inpFtpVO) {
        FTPClient tmpClient = null;
        try {
            boolean ret = false;

            tmpClient = new FTPClient();
            tmpClient
                    .connect(inpFtpVO.getServer(), inpFtpVO.getPortasInteger()); // void
            if (debug)
                System.out.println("rAO connect " + tmpClient.getReplyString());

            ret = tmpClient.login(inpFtpVO.getUser(), inpFtpVO.getPassword()); // bool
            if (debug)
                System.out.println("rAO login " + ret + " / "
                        + tmpClient.getReplyString());

            ret = tmpClient.changeWorkingDirectory(inpFtpVO.getDirectory()); // bool
            if (debug)
                System.out.println("rAO cwd " + ret + " / "
                        + tmpClient.getReplyString());

            ret = tmpClient.setFileType(FTP.BINARY_FILE_TYPE); // bool
            if (debug)
                System.out.println("rAO binary " + ret + " / "
                        + tmpClient.getReplyString());

            tmpClient.enterLocalPassiveMode(); // void
            if (debug)
                System.out.println("rAO PASV " + tmpClient.getReplyString());

            String[] commands = getUserFTPCommand();

            for (int i = 0; i < commands.length; i++) {
                if (commands[i] != null && commands[i].length() > 0) {
                    tmpClient.sendCommand(commands[i]); // bool
                    if (debug)
                        System.out.println("rAO cmd "
                                + tmpClient.getReplyString());
                }
            }

        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpClient;
    }

    /**
     * Copied from XInputFileImpl.randomAccessClose()
     * 
     * @param tmpClient
     */
    public void closeClient(FTPClient tmpClient) {
        try {
            // no need to abort a transfer explicitly, because we logout here

            boolean ret = false;
            if (debug)
                System.out.println("rAC last " + tmpClient.getReplyCode()
                        + " / " + tmpClient.getReplyString());

            ret = tmpClient.isConnected();
            if (debug)
                System.out.println("rAC isCon " + ret + " / "
                        + tmpClient.getReplyCode() + " / "
                        + tmpClient.getReplyString());

            // ret = tmpClient.completePendingCommand();
            // if (debug)
            // System.out.println("rAC complete " + ret + " / "
            // + tmpClient.getReplyCode() + " / "
            // + tmpClient.getReplyString());

            ret = tmpClient.logout();
            if (debug)
                System.out.println("rAC logout " + ret + " / "
                        + tmpClient.getReplyCode() + " / "
                        + tmpClient.getReplyString());

            ret = tmpClient.isConnected();
            if (debug)
                System.out.println("rAC isCon " + ret + " / "
                        + tmpClient.getReplyCode() + " / "
                        + tmpClient.getReplyString());

            if (ret) {
                try {
                    tmpClient.disconnect();
                    if (debug)
                        System.out.println("rAC disc "
                                + tmpClient.getReplyCode() + " / "
                                + tmpClient.getReplyString());
                } catch (IOException e) {
                    if (debug)
                        System.out.println("rAC disc-er " + e);
                }
            }
            if (debug)
                System.out.println("rAC out ");
        } catch (IOException exc) {
            GConsole.setErrorMessage(exc);
        }
    }

    /**
     * 
     * @param inpDir
     * @return FtpVO
     */
    public FtpVO makeVOFrom(XInputDirectory inpDir) {
        try {
            XInputDirectory tmpXDirectory = inpDir;
            String tmpDirectory = tmpXDirectory.getDirectory();
            String tmpServer = tmpXDirectory.getServer();
            String tmpUser = tmpXDirectory.getUser();
            String tmpPassword = tmpXDirectory.getPassword();
            String tmpPort = tmpXDirectory.getPort();
            FtpVO tmpVO = new FtpVO(tmpServer, tmpUser, tmpPassword,
                    tmpDirectory, tmpPort, null);
            return tmpVO;
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return null;
    }

    /**
     * 
     * @param inpFile
     * @return XInputDirectory
     */
    public XInputDirectory makeDirectoryFrom(XInputFile inpFile, FtpVO inpVO) {
        try {
            String tmpDirectory = inpFile.getParent() + "/" + inpFile.getName();
            String tmpServer = inpVO.getServer();
            String tmpUser = inpVO.getUser();
            String tmpPassword = inpVO.getPassword();
            String tmpPort = inpVO.getPort();
            FtpVO tmpVO = new FtpVO(tmpServer, tmpUser, tmpPassword,
                    tmpDirectory, tmpPort, null);
            XInputDirectory tmpIDirectory = new XInputDirectory(tmpVO);
            if (tmpIDirectory.test()) {
                return tmpIDirectory;
            }
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return null;
    }

    /**
     * 
     */
    private XInputFile[] listFiles(FTPClient inpClient, FtpVO inpVO)
            throws IOException {
        FTPFile[] tmpFTPFiles = null;
        tmpFTPFiles = inpClient.listFiles();
        int anz = (tmpFTPFiles == null) ? 0 : tmpFTPFiles.length;
        List tmpList = new ArrayList(anz);
        for (int i = 0; i < anz; i++) {
            FTPFile tmpFTPFile = tmpFTPFiles[i];
            String tmpFN = tmpFTPFile.getName();
            if (".".equals(tmpFN) || "..".equals(tmpFN)) {
                continue;
            }
            FtpVO tempFtpVO = (FtpVO) inpVO.clone();
            tempFtpVO.setFtpFile(tmpFTPFiles[i]);
            tmpList.add(new XInputFile(tempFtpVO));
        } // for i
        anz = (tmpList == null) ? 0 : tmpList.size();
        XInputFile[] ftpInputFiles = new XInputFile[anz];
        for (int i = 0; i < anz; i++) {
            ftpInputFiles[i] = (XInputFile) tmpList.get(i);
        } // for i
        return ftpInputFiles;
    }

    /**
     * 
     * @param inpDir
     * @return
     */
    public XInputFile[] getFilesAndDirectories(XInputDirectory inpDir) {
        XInputFile[] tmpXFiles = null;
        try {
            FtpVO tmpFtpVO = makeVOFrom(inpDir);
            FTPClient tmpClient = openClient(tmpFtpVO);
            tmpXFiles = listFiles(tmpClient, tmpFtpVO);
            closeClient(tmpClient);
        } catch (Exception exc) {
            GConsole.setErrorMessage(exc);
        }
        return tmpXFiles;
    }

}
